<?php

function sm_register_shortcode_handler_sm_social_links() {
	if ( defined( 'WPB_VC_VERSION' ) ) {
		class WPBakeryShortCode_sm_social_links extends WPBakeryShortCode {
			function content($atts, $content = null) {
				return sm_social_links_func( $atts, $content );
			}
		}
	} else {
		add_shortcode( 'sm_social_links', 'sm_social_links_func' );
	}
}

function sm_social_links_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'social-links', $view_params );
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Social Links', 'semona-extension' ),
	'base' => 'sm_social_links',
	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
	'description' => esc_html__( 'Social Links', 'semona-extension' ),
	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-social_links.png',
	'params' => array_merge(
		array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'semona-extension' ),
				'param_name' => 'style',
				'description' => esc_html__( 'Select social link style', 'semona-extension' ),
				'value' => sm_get_social_links_styles_array(),
				'admin_label' => true,
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Shape', 'semona-extension' ),
				'param_name' => 'shape',
				'description' => esc_html__( 'Select social link icon shape', 'semona-extension' ),
				'value' => sm_get_social_links_shapes_array(),
				'admin_label' => true,
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Alignment', 'semona-extension' ),
				'param_name' => 'align',
				'description' => esc_html__( 'Select alignment of social link icons.', 'semona-extension' ),
				'value' => sm_get_default_aligns_array(),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__( 'Color', 'semona-extension' ),
				'param_name' => 'color',
				'description' => esc_html__( 'Select social icon color.', 'semona-extension' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			array(
				'type' => 'checkbox',
				'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),
				'param_name' => 'open_new',
				'edit_field_class' => 'vc_col-sm-6 vc_column',
			),
			sm_css_animation_class(),
			sm_css_animation_delay(),
			sm_extra_class()
		),
		sm_get_social_links_options_array()
	),
) );